# #######################################################################
# Wpager.pm: Global object encapsulating splitting of HTML slides 
#   Copyright (C) 2000 by Steve Litt (slitt@troubleshooters.com)
#   Version 0.5, 4/13/2000 by Steve Litt
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Steve Litt, slitt@troubleshooters.com, http://www.troubleshooters.com
# #######################################################################

package Wpager;
use strict;

sub new {
  my($type) = $_[0];
  my($self) = {};
  my($temp);
  $self->{'presentationFilename'} = $_[1];
  $self->{'slideTemplateFilename'} = $_[2];
  $self->{'indexTemplateFilename'} = $_[3];
  $self->{'indexHTMLFilename'} = $_[4];
  $self->{'pageno'} = 0;
  $self->{'maxPageno'} = 0;
  $self->{'indents'} = 0;
  $self->{'title'} = '';
  $self->{'inTitle'} = 0;
  $self->{'needHeader'} = 0;
  $self->{'pageText'} = ();
  $self->{'pageList'} = ();
  bless($self, $type);
  $self->prepass();
  open(TEMPFILE, $self->{'presentationFilename'}) or die "Wpager->new() couldnt open $self->{'presentationFilename'}.\n";
  $self->{'infile'} = \*TEMPFILE;
  $self->doit();
  return($self);
}

sub doit {
  my($self) = $_[0];
  my($remainderString) = $self->findFirstAddress();
  while($remainderString) {
    $remainderString = $self->doPage($remainderString);
  }
  $self->writeIndexToDisk();
}

sub findFirstAddress {
  my($self)=$_[0];
  my($line) = $self->nextLine();
  while(defined($line)) {
    chomp($line);
    if($line =~ m/<address>/i) {
      my(@lines)=split(/<address>/, $line);
      return($self->_forceDefine($lines[1]));
    }
    $line = $self->nextLine();
  }
  return();
}


sub doPage {
  my($self)=$_[0];
  my($line) = $_[1];

  $self->{'pageno'}++;
  $self->{'indents'}=0;
  $self->{'title'} = '';
  $self->{'pageText'} = ();
  my($nextPageFound) = 0;

  ##### FIND TITLE #####
  my($remainderString);
  while(defined($line)) {
    chomp($line);
    $remainderString = $self->checkAndAddToTitle($self->_forceDefine($line));
    if($remainderString ne "cNtNe") {
      last;
    }
    $line = $self->nextLine();
  }
  $line = $self->_forceDefine($remainderString);
  push(@{$self->{'pageList'}}, $self->{'title'});
  

  ##### HANDLE REST OF PAGE #####
  my(@lines)=();
  while(defined($line)) {
    chomp($line);
    if($line =~ m/<address>/i) {
      $nextPageFound = 1;
      my(@lines)=split(/<address>/, $line);
      $lines[0] = $self->_forceDefine($lines[0]);
      $lines[1] = $self->_forceDefine($lines[1]);
      $line=$lines[0];
    }
    $line = $self->addBlockquotes($line);
    $line = $self->_killEndBody($line);
    push(@{$self->{'pageText'}}, $line); 
    if($nextPageFound) {last;}
    $line=$self->nextLine();
  }

  $self->writePageToDisk();

  if($nextPageFound) {
    $line=$self->_forceDefine($lines[1]);
  }
  return($line);
}


sub writePageToDisk {
  my($self)=$_[0];
  
  my($templatename) = '<' . $self->{'slideTemplateFilename'};
  open(INFILE, $templatename) or die "Wpager->writePageToDisk couldnt read $templatename";  
  my(@templateLines) = <INFILE>;
  close(INFILE);

  my($outfilename) = $self->_makePageFilename($self->{'pageno'});
  open(OUTFILE, '>' . $outfilename) or die "Wpager->writePageToDisk couldnt write $outfilename";

  @templateLines = $self->_putZZZonOwnLine(@templateLines);
  # print join("\n", @templateLines);
 
  my($line);
  foreach $line (@templateLines) {
    $line=$self->_forceDefine($line);
    if($line eq "zzzNAVzzz") {
      print OUTFILE join("\n", $self->makeNavigator());
    }
    elsif($line eq "zzzTITLEzzz") {
      print OUTFILE join("\n", $self->{'title'});
    }
    elsif($line eq "zzzSLIDEzzz") {
      print OUTFILE join("\n", @{$self->{'pageText'}});
    }
    elsif($line eq "zzzPAGENOzzz") {
      print OUTFILE $self->_makePageFilename($self->{'pageno'}); 
    }
    else {
      print OUTFILE "$line\n";
    }
  }
  close(OUTFILE);
}


sub writeIndexToDisk {
  my($self)=$_[0];
  
  my($templatename) = '<' . $self->{'indexTemplateFilename'};
  open(INFILE, $templatename) or die "Wpager->writeIndexToDisk couldnt read $templatename";  
  my(@templateLines) = <INFILE>;
  close(INFILE);

  my($outfilename) = $self->{'indexHTMLFilename'};
  open(OUTFILE, '>' . $outfilename) or die "Wpager->writeIndexToDisk couldnt write $outfilename";

  @templateLines = $self->_putZZZonOwnLine(@templateLines);
  # print join("\n", @templateLines);
 
  my($line);
  foreach $line (@templateLines) {
    $line=$self->_forceDefine($line);
    if($line eq "zzzCONTENTSzzz") {
      my($temp);
      my($ss)=1;
      foreach $temp (@{$self->{'pageList'}}) {
        my($fn) = $self->_makePageFilename($ss);
        print OUTFILE "<a href=\"" . $fn . "\">" . $temp . "</a><br>\n";
	$ss++;
      }
    }
    else {
      print OUTFILE "$line\n";
#      print "$line\n";
    }
  }
  close(OUTFILE);
}

sub _putZZZonOwnLine {
  my($self) = shift;
  my(@inputLines) = @_;
  my(@outputLines) = ();
  my($line);
  foreach $line (@inputLines){
    chomp($line);
    $line =~ s/(zzz.+?zzz)/YxYxY$1YxYxY/g;
#    print "$line\n";
    my(@lines) = split(/YxYxY/, $line);
    push(@outputLines, @lines);
  }
  return(@outputLines);
}


sub checkAndAddToTitle {
  my($self)=$_[0];
#  my($line) = $self->_forceDefine($_[1]);
  my($line) = $self->_forceDefine($_[1]);
  if($line =~ m/<\/address>/i) {
    my(@lines)=split(/<\/address>/, $line);
    $self->{'title'} = $self->{'title'} . ' ' . $lines[0];
    return($self->_forceDefine($lines[1]));
  }
  $self->{'title'} = $self->{'title'} . ' ' . $line;
  return("cNtNe");
}


sub nextLine {
  my($self)=$_[0];
  my($fh) = $self->{'infile'};
  return(scalar <$fh>);
}


sub prepass {
  my($self)=$_[0];
  $self->{'maxPageno'} = 0;
  open(INPUTFILE, "<" . $self->{'presentationFilename'}) or die "prepass() couldnt open $self->{'presentationFilename'}";
  while(<INPUTFILE>) {
    my($line) = $_;
    chomp($line);
    while($line =~ m/<address>/g) {
      $self->{'maxPageno'}++;
    }
  }
  close(INPUTFILE);
}


sub _forceDefine {
  if(defined($_[1])) {
    return($_[1]);
  }
  else {
    return(' ');
  }
}


sub _makePageFilename {
  my($self)=$_[0];
  return ($_[1] . "\.html");
}

sub makeNavigator {
  my($self) = $_[0];
  my($prevno) = $self->{'pageno'} - 1;
  my($thisno) = $self->{'pageno'};
  my($nextno) = $self->{'pageno'} + 1;
  my($prevHtml) = $self->_makePageFilename($prevno);
  my($thisHtml) = $self->_makePageFilename($thisno);
  my($nextHtml) = $self->_makePageFilename($nextno);
  my(@return) = ();

  my($line);

  if($prevno > 0) {
    $line = "<a href=\"$prevHtml\">&lt;&lt;&lt;&lt;</a>";
  }
  else {
    $line = "&lt;&lt;&lt;&lt;";
  }
  push(@return, $line);

  $line = "<a href=\"" . $self->{'indexHTMLFilename'} . "\">^^^^^</a>";
  push(@return, $line);

  if($nextno <= $self->{'maxPageno'}) {
    $line = "<a href=\"$nextHtml\">>>>></a>";
  }
  else {
    $line = ">>>>>";
  }
  push(@return, $line);
  return(@return); 
}



sub _killEndBody {
  my($self)=$_[0];
  my($line)=$_[1];
  $line =~ s/<\/body>/ /gi;
  $line =~ s/<\/html>/ /gi;
  return($line);
}

sub addBlockquotes {
  my($self)=$_[0];
  my($line) = $_[1];
  $line =~ s/<h2>/<blockquote><h2>/ig;
  $line =~ s/<h3>/<blockquote><blockquote><h3>/ig;
  $line =~ s/<h4>/<blockquote><blockquote><blockquote><h4>/ig;
  $line =~ s/<h5>/<blockquote><blockquote><blockquote><blockquote><h5>/ig;
  $line =~ s/<h6>/<blockquote><blockquote><blockquote><blockquote><blockquote><h6>/ig;

  $line =~ s/<\/h6>/<\/h6><\/blockquote><\/blockquote><\/blockquote><\/blockquote><\/blockquote>/ig;
  $line =~ s/<\/h5>/<\/h5><\/blockquote><\/blockquote><\/blockquote><\/blockquote>/ig;
  $line =~ s/<\/h4>/<\/h4><\/blockquote><\/blockquote><\/blockquote>/ig;
  $line =~ s/<\/h3>/<\/h3><\/blockquote><\/blockquote>/ig;
  $line =~ s/<\/h2>/<\/h2><\/blockquote>/ig;
  return($line);
}

sub shortCopyright{
  print "HTML Slides: Copyright (C) 2000 by Steve Litt (NO WARRANTEE! See GPL license)\n";
}

1
