#!/usr/bin/perl -w

# Copyright (C) 2002 by Steve Litt
# Licensed under the GNU General Public License
# NO WARRANTEE! See license at http://www.gnu.org/licenses/gpl.txt
# version 0.0.1, 6/4/2002

use strict;


# optionsObj is intended to be a global object
my($optionsObj) = Options->new($ENV{'HOME'} . "/.logeval/logeval.conf");

######################################################################
############ Breaklogic and Writer objects are the only ones #########
############ meant to be modified. The program's design      #########
############ assumes all other code will not be modified.    #########
######################################################################

package Breaklogic;
sub new($$)
	{
	my($type) = $_[0];
	my($self) = {};
	$self->{'dailyAccumulator'}=Accumulator->new();
	$self->{'yesterdayAccumulator'} = Accumulator->new();
	$self->{'reportAccumulator'} = Accumulator->new();
	$self->{'yesterdayDatestamp'}='00000000';
	$self->{'lastCompleteDayDatestamp'} = '00000000';
	$self->{'reportFirstCompleteDate'} = '00000000';
	$self->{'reportLastCompleteDate'} = '00000000';
	

	bless($self, $type);
	return($self);
	}

sub prime()   # to be called before the loop in main()
	{
	if($optionsObj->specialEventsArray()->moreEvents())
		{
		$optionsObj->specialEventsArray()->nextEvent();
		}
	}

sub break()
	{
	my($self) = $_[0];
	my($newDateStamp) = $_[1];
	my($oldAccumulator) = $_[2];

	my($eventDatestamp) = $optionsObj->specialEventsArray()->thisEventDatestamp();
	unless(defined($eventDatestamp)) {$eventDatestamp = "00000000"};

	# Finish the old accumulator
	unless($self->{'yesterdayDatestamp'} eq "00000000")
		{
		$oldAccumulator->finalSorts();
		my($dailyWriter) = Writer->new($oldAccumulator);
		if($self->{'lastCompleteDayDatestamp'} eq '00000000')
			{
			$dailyWriter->setPartialDay(1);
			$self->{'reportFirstCompleteDate'} = $newDateStamp
			}
		else
			{
			# Accumulate only full days
			$self->{'reportAccumulator'}->addOtherAccumulator($oldAccumulator);
			}
		while(($eventDatestamp lt $self->{'yesterdayDatestamp'}) && ($optionsObj->specialEventsArray()->moreEvents()))
			{
			$optionsObj->specialEventsArray()->nextEvent();
			$eventDatestamp=$optionsObj->specialEventsArray()->thisEventDatestamp();
			}
		if($eventDatestamp eq $self->{'yesterdayDatestamp'})
			{
			print "\n\n**** EVENT ***: " . $optionsObj->specialEventsArray()->thisEvent() . "\n";
			}

		$dailyWriter->setNumberOfTopUrlsToReport(10);
		$dailyWriter->setStartDate($self->{'yesterdayDatestamp'});
		$dailyWriter->setEndDate($self->{'yesterdayDatestamp'});
		$dailyWriter->addSpecialUrlArray($optionsObj->getSpecialUrlArrayReference());
		$dailyWriter->printAll();
		}

	# Set up the new accumulator
	my($newAccumulator) = Accumulator->new();

	# Set the old to the current
	$self->{'lastCompleteDayDatestamp'} = $self->{'yesterdayDatestamp'};
	$self->{'yesterdayDatestamp'} = $newDateStamp;
	$self->{'yesterdayAccumulator'} = $oldAccumulator;

	# Return the new daily accumulator
	return($newAccumulator);
	}

sub wrapup()
	{
	my($self) = $_[0];;
	my($newDateStamp) = $_[1];
	my($oldAccumulator) = $_[2];


	#Print partial Day (last day)
	my($dailyWriter) = Writer->new($oldAccumulator);
	$oldAccumulator->finalSorts();
	$dailyWriter->setPartialDay(1);
	$dailyWriter->setNumberOfTopUrlsToReport(10);
	$dailyWriter->setStartDate($self->{'yesterdayDatestamp'});
	$dailyWriter->setEndDate($self->{'yesterdayDatestamp'});
	$dailyWriter->addSpecialUrlArray($optionsObj->getSpecialUrlArrayReference());
	$dailyWriter->printAll();

	# Print Whole Report (only for full days)
	$self->{'reportLastCompleteDate'} = $self->{'lastCompleteDayDatestamp'};
	$self->{'reportAccumulator'}->addOtherAccumulator($oldAccumulator);
	$self->{'reportAccumulator'}->finalSorts();
	my($globalWriter) = Writer->new($self->{'reportAccumulator'});
	$globalWriter->setNumberOfTopUrlsToReport(999999);
	$globalWriter->setStartDate($self->{'reportFirstCompleteDate'});
	$globalWriter->setEndDate($self->{'reportLastCompleteDate'});
	$globalWriter->addSpecialUrlArray($optionsObj->getSpecialUrlArrayReference());
	$globalWriter->printAll();
	}


package Writer;
use POSIX qw(mktime);
sub new($$)
	{
	my($type) = $_[0];
	my($self) = {};
	bless($self, $type);
	$self->{'startdate'} = "0000";
	$self->{'enddate'} = "0000";
	my(@specialurls) = ();
	$self->{'specialurls'} = \@specialurls;
	$self->{'numurls2report'} = 10;
	$self->{'numips2report'} = 10;
	$self->{'accumulator'} = $_[1];
	$self->{'partialday'} = 0;
	return($self);
	}

sub isPartialDay($){return($_[0]->{'partialday'});}
sub setPartialDay($$){$_[0]->{'partialday'} = $_[1];}
sub getStartDate($){return($_[0]->{'startdate'});}
sub setStartDate($$){$_[0]->{'startdate'} = $_[1];}
sub getEndDate($){return($_[0]->{'enddate'});}
sub setEndDate($$){$_[0]->{'enddate'} = $_[1];}
sub addSpecialUrl($$){push(@{$_[0]->{'specialurls'}}, ($_[1]));}
sub getNumberOfTopUrlsToReport($){return($_[0]->{'numurls2report'});}
sub setNumberOfTopUrlsToReport($$){$_[0]->{'numurls2report'} = $_[1];}
sub addSpecialUrlArray($\@)
	{
	push(@{$_[0]->{'specialurls'}}, @{$_[1]});
	}

sub printAll($)
	{
	my($self) = $_[0];
	printf("\nTOP AND SPECIAL URL's FOR %s THROUGH %s", $self->{'startdate'}, $self->{'enddate'});
	if($self->{'startdate'} eq $self->{'enddate'})
		{
		print "   (" . $self->yyyymmdd2dayOfWeek($self->{'startdate'}) . ")    ";
		}
	if($self->isPartialDay())
		{
		print " *** WARNING: PARTIAL DAY ***";
		}
	print "\n";
	printf("%d distinct IP\'s, %d total page hits.\n\n", scalar(keys(%{$self->{'accumulator'}->{'ips'}})), $self->{'accumulator'}->totalPageHits());
	$self->printTopUrls();
	print "\n";
	$self->printSpecialUrls();
	}

sub yyyymmdd2dayOfWeek($$)
	{
	my($self) = $_[0];
	my($datestamp) = $_[1];
	my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday)=(0,0,0,0,0,0,0,0);
	my($time) = 0;
	if($datestamp =~ m/(\d{4})(\d\d)(\d\d)/)
		{
		$year = int($1)-1900;
		$mon = int($2) - 1;
		$mday = int($3);
		$hour = 0;           
		$min = 0;
		$sec = 30;               # make sure it's pushed past midnight
		$time = mktime(($sec,$min,$hour,$mday,$mon,$year,$wday,$yday));
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = localtime($time);
		my(@daynames) = ("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
		return($daynames[$wday]);
		}
	return("Undefined day");
	}


sub printTopUrls($)
	{
	my($self) = $_[0];
	my($accumref) = $self->{'accumulator'};
	my($urlRef);
	my($count) = 0;
	while($accumref->moreUrlRecords() && $count < $self->{'numurls2report'})
		{
		my($urlRef) = $accumref->getNextUrlRecord();
		printf("%4d:    %8d:     %s\n",$count+1, $urlRef->[1], $urlRef->[0]);
		$count++;
		}
	}

sub printSpecialUrls($)
	{
	my($self) = $_[0];
	my($accumref) = $self->{'accumulator'};
	my($specialUrl);
	foreach $specialUrl (@{$self->{'specialurls'}})
		{
		my($accesses) = $accumref->getUrlRecord($specialUrl);
		unless(defined($accesses))
			{
			$accesses=0;
			}

		printf("         %8d:     %s\n", $accesses, $specialUrl);
		}
	}

sub printTopIps($)
	{
	my($self) = $_[0];
	my($accumref) = $self->{'accumulator'};
	my($ipRef);
	my($count) = 0;

	while($accumref->moreIpRecords() && $count < $self->{'numips2report'})
		{
		my($ipRef) = $accumref->getNextIpRecord();
		printf("%4d:    %8d:     %s\n",$count+1, $ipRef->[1], $ipRef->[0]);
		$count++;
		}
	}


######################################################################
############ The classes from here down are designed not to  #########
############ be modified. The program design envisions all   #########
############ program customization being done by mods to     #########
############ the Breaklogic or Writer classes only, or       #########
############ decendents of the Writer class.                 #########
######################################################################

package Specialevents;

sub new($$)
	{
	my($type) = $_[0];
	my($self) = {};
	$self->{'specialeventsfilename'} = $_[1];
	bless($self, $type);
	my(@lines) = ();
	$self->{'elements'} = 0;
	if(open(INF, "<" . $_[1]))
		{
		while(<INF>)
			{
			my($line) = $_;
			chomp($line);
			push(@lines, ($line));
			$self->{'elements'}++;
			}
		close(INF);
		}
	@{$self->{'specialeventsarray'}} =
		sort { $self->datestamp($a) <=> $self->datestamp($b) }
			(@lines);
	$self->{'specialeventssubscript'} = -1;
	return($self);
	}

sub moreEvents($)
	{
	if($_[0]->{'specialeventssubscript'} < scalar($_[0]->{'elements'}) - 1)
		{
		return (1);
		}
	else
		{
		return(0);
		}
	}

sub thisEventText($)
	{
	my($self) = $_[0];
	my($string) = $self->{'specialeventsarray'}->[$self->{'specialeventssubscript'}];
	my($timestamp, $remainder) = split(/ /, $string, 2);
	return($remainder);
	}

sub thisEventTimestamp($)
	{
	my($self) = $_[0];
	my($string) = $self->{'specialeventsarray'}->[$self->{'specialeventssubscript'}];
	my($timestamp, $remainder) = split(/ /, $string, 2);
	return($timestamp);
	}

sub datestamp($$)
	{
	my($self) = $_[0];
	my($string) = $_[1];
	if($string =~ m/(\d{4})\/?(\d\d)\/?(\d\d)/)
		{return($1 . $2 . $3);}
	else
		{return("11111111");}
	}

sub thisEventDatestamp($){return($_[0]->datestamp(
   $_[0]->{'specialeventsarray'}->[$_[0]->{'specialeventssubscript'}]
	                                                  ));}

sub thisEvent($)
	{
	return($_[0]->{'specialeventsarray'}->[$_[0]->{'specialeventssubscript'}]);
	}

sub nextEvent($)
	{
	$_[0]->{'specialeventssubscript'}++;
	return($_[0]->{'specialeventsarray'}->[$_[0]->{'specialeventssubscript'}]);
	}
sub getSubscript($){return($_[0]->{'specialeventssubscript'});}
sub setSubscript($$){$_[0]->{'specialeventssubscript'} = $_[1];}

package Options;
sub new($$)
	{
	my($type) = $_[0];
	my($self) = {};
	$self->{'optionsfilename'} = $_[1];
	bless($self, $type);
	$self->{'specialevents'} = Specialevents->new($ENV{'HOME'} . "/.logeval/specialevents.list");
	my(@specialurlarray) = ();
	$self->{'specialurlarray'} = \@specialurlarray; 
	open(INF, "<" . $self->{'optionsfilename'}) or die "Cannot open options file " . $self->{'optionsfilename'} . "\n\n";
	while(<INF>)
		{
		my($line) = $_;
		chomp($line);
		if   ($line =~ m/log\s*wild\s*card\s*=\s*(\S*)/i)
			{$self->{'logwildcard'} = $1;}
		elsif($line =~ m/special\s*url\s*=\s*(\S*)/i)
			{push(@{$self->{'specialurlarray'}}, ($1));}
		   
		}
	unless(defined($self->{'logwildcard'}))
		{die "No log wildcard defined in ". $self->{'optionsfilename'} . "\n\n";}
	return($self);
	}

sub getLogWildcard($){return($_[0]->{'logwildcard'});}
sub setLogWildcard($$){$_[0]->{'logwildcard'} = $_[1];}
sub getSpecialUrlArrayReference($){return($_[0]->{'specialurlarray'});}
sub pushSpecialUrlArrayReference($){push(@{$_[0]->{'specialurlarray'}}, ($_[1]));}
sub zeroSpecialUrlArrayReference($){my(@temp)=(); $_[0]->{'specialurlarray'} = \@temp;}
sub specialEventsArray($){return($_[0]->{'specialevents'});}


package Accumulator;
sub new($)
	{
	my($type) = $_[0];
	my($self) = {};
	bless($self, $type);
	my(%ips) = ();
	my(@ipkeys) = ();
	$self->{'startdate'} = "0000";
	$self->{'enddate'} = "0000";
	$self->{'ips'} = \%ips;
	$self->{'ipkeys'} = \@ipkeys;
	$self->{'ipkeysubscript'} = 0;
	my(%urls) = ();
	my(@urlkeys) = ();
	$self->{'urls'} = \%urls;
	$self->{'urlkeys'} = \@urlkeys;
	$self->{'urlkeysubscript'} = 0;
	$self->{'totalbytes'} = 0;
	my(@specialurls) = ();
	$self->{'specialurls'} = \@specialurls;
	$self->{'numurls2report'} = 10;
	return($self);
	}

sub addOtherAccumulator($$)
	{
	my($self) = $_[0];
	my($otherAccumulator) = $_[1];
	my(@keys) = keys(%{($otherAccumulator->{'urls'})});
	my($key);
	foreach $key (@keys)
		{
		unless(defined($self->{'urls'}->{$key}))
			{
			$self->{'urls'}->{$key} = 0;
			}
		$self->{'urls'}->{$key} += $otherAccumulator->{'urls'}->{$key};
		}
	@keys = keys(%{($otherAccumulator->{'ips'})});
	foreach $key (@keys)
		{
		unless(defined($self->{'ips'}->{$key}))
			{
			$self->{'ips'}->{$key} = 0;
			}
		$self->{'ips'}->{$key} += $otherAccumulator->{'ips'}->{$key};
		}
	}
sub getIpKeySubscript($){return($_[0]->{'ipkeysubscript'});}
sub setIpKeySubscript($$){$_[0]->{'ipkeysubscript'} = $_[1];}
sub getUrlKeySubscript($){return($_[0]->{'urlkeysubscript'});}
sub setUrlKeySubscript($$){$_[0]->{'urlkeysubscript'} = $_[1];}

sub addSpecialUrl($$){push(@{$_[0]->{'specialurls'}}, ($_[1]));}
sub getDistinctIPs($) {return(scalar(keys(%{$_[0]->{'ips'}})));}

sub getNextSpecialUrl(){}
sub finalSorts($)
	{
	my($self) = $_[0];

	my(%temp) = %{$self->{'urls'}};
	my(@urlkeys) = sort { $temp{$b} <=> $temp{$a} } keys %temp;
	$self->{'urlkeys'} = \@urlkeys;
	$self->{'urlkeysubscript'} = 0;
	%temp = %{$self->{'ips'}};
	my(@ipkeys) = sort { $temp{$b} <=> $temp{$a} } keys %temp;
	$self->{'ipkeys'} = \@ipkeys;
	$self->{'ipkeysubscript'} = 0;
	}

sub moreIpRecords($)
	{
	if($_[0]->{'ipkeysubscript'} < scalar($_[0]->{'ipkeys'}))
		{return(1);}
	else
		{return(0);}
	}
	
sub getIpRecord($$)
	{
	return($_[0]->{'ip'}->{$_[1]});
	}

sub totalPageHits($)
	{
	my($self) = $_[0];
	my($pagehits) = 0;
	my($key);
	foreach $key (@{$self->{'urlkeys'}})
		{
		$pagehits += $self->{'urls'}->{$key};
		}
	return ($pagehits);
	}

sub moreUrlRecords($)
	{
	if($_[0]->{'urlkeysubscript'} < scalar(@{$_[0]->{'urlkeys'}}))
#	if($_[0]->{'urlkeysubscript'} < 8)
		{return(1);}
	else
		{return(0);}
	}
	
sub getNextIpRecord($)
	{
	my($self) = $_[0];
	my($key) = $self->{'ipkeys'}->[$self->{'ipkeysubscript'}];
	my(@return) = ($key, $self->{'ipkeys'}->{$key});
	$self->{'urlkeysubscript'}++;
	return (\@return);
	}

sub getUrlRecord($$)
	{
	return($_[0]->{'urls'}->{$_[1]});
	}
sub getNextUrlRecord($)
	{
	my($self) = $_[0];
	my($key) = $self->{'urlkeys'}->[$self->{'urlkeysubscript'}];
	my(@return) = ($key, $self->{'urls'}->{$key});
#	my(@return) = (5, "/d/web/sites");
	$self->{'urlkeysubscript'}++;
	return (\@return);
	}

sub addHit($$$$$)
	{
	my($self) = $_[0];
	my($ip) = $_[1];
	my($timestamp) = $_[2];
	my($url) = $_[3];
	my($size) = $_[4];

	my($count) = $self->{'urls'}->{$url};
	if(defined($count))
		{
		$self->{'urls'}->{$url} = $count + 1;
		}
	else
		{
		$self->{'urls'}->{$url} = 1;
		}
	

	$count = $self->{'ips'}->{$ip};
	if(defined($count))
		{
		$self->{'ips'}->{$ip} = $count + 1;
		}
	else
		{
		$self->{'ips'}->{$ip} = 1;
		}
	$self->{'totalbytes'} += $size;
	}
	
package Programlogic;

sub testSpecial($)
	{
	my($self) = $_[0];
	my($spec) = Specialevents->new($ENV{'HOME'} . "/.logeval/specialevents.list");

	while($spec->moreEvents())
		{
		my($line) = $spec->nextEvent();
		print $spec->thisEventDatestamp() . "    ";
		print "$line\n";
		}
	}

sub fixdate($$)
	{
	my($dd,$MM,$yyyy,$hh,$mm,$ss,$remainder,$junk,$month);
	($dd, $month, $remainder) = split(/\//, $_[1]);
	($yyyy,$hh,$mm,$ss) =  split(/:/, $remainder);
	$month=uc($month);
	if   ($month eq "JAN") {$MM = "01";}
	elsif($month eq "FEB") {$MM = "02";}
	elsif($month eq "MAR") {$MM = "03";}
	elsif($month eq "APR") {$MM = "04";}
	elsif($month eq "MAY") {$MM = "05";}
	elsif($month eq "JUN") {$MM = "06";}
	elsif($month eq "JUL") {$MM = "07";}
	elsif($month eq "AUG") {$MM = "08";}
	elsif($month eq "SEP") {$MM = "09";}
	elsif($month eq "OCT") {$MM = "10";}
	elsif($month eq "NOV") {$MM = "11";}
	elsif($month eq "DEC") {$MM = "12";}
	else {$MM = "MM";}
	return($yyyy . $MM . $dd . "@" . $hh . ":" . $mm . ":" . $ss);
	}

sub fixip($$)
	{
	my(@parts) = split(/\./, $_[1]);
	my($part);
	my($return) = "";
	foreach $part (@parts)
		{
		$part = "00" . $part;
		$part = substr($part, length($part)-3);
		if($return eq "")
			{$return = $part;}
		else
			{$return = $return . "." . $part;}

		}
	return($return);
	}

sub new()
	{
	my($type) = $_[0];
	my($self) = {};
	bless($self, $type);
	my($recno) = 0;
	my($globalAccumulator) = Accumulator->new();
	my($previousDateStamp) = "00000000";
	my($dateStamp) = "               ";
	my($dailyWriter);
	my($dailyAccumulator);
	my($prior7Writer);
	my($prior7Accumulator);
	my($breakLogic) =  Breaklogic->new();
	$breakLogic->prime();
	while(<STDIN>)
		{
		my($line) = $_;
		chomp($line);
		$recno++;
		my($remainder);
		my($junk);
		my($ip) = "invalid";
		my($date) = "invalid";
		my($url) = "invalid";
		($ip, $remainder) = split(/ /, $line, 2);
		($junk, $remainder) =  split(/\[/, $remainder, 2);
		($date, $remainder) = split(/ /, $remainder, 2);
		($junk, $remainder) = split(/\//, $remainder, 2);
		($url, $remainder) =  split(/ /, $remainder, 2);
		$url =~ s/\/+/\//g;
		$url = "/" . $url;
		$date = $self->fixdate($date);
		$ip = $self->fixip($ip);
		($dateStamp, $remainder) = split(/@/, $date);
		if($dateStamp ne $previousDateStamp)
			{
			$dailyAccumulator = $breakLogic->break($dateStamp, $dailyAccumulator);
			$previousDateStamp = $dateStamp;
			}
		$dailyAccumulator->addHit($ip,$date,$url,0);
		}
	$dailyAccumulator = $breakLogic->wrapup($dateStamp, $dailyAccumulator);
	print "\nTotal records=$recno\n";
	}

package Main;

my($pgmlogic) = Programlogic->new();
