#!/usr/bin/perl -w
# #!/usr/local/bin/perl -w
# Copyright (C) 2002 by Steve Litt
# Licensed under the GNU General Public License
# NO WARRANTEE! See license at http://www.gnu.org/licenses/gpl.txt
# version 0.0.1, 6/4/2002

use strict;

sub datestamp($)
	{
	my($filename) = $_[0];
	my($datestamp);
	if($filename =~ m/\.(\d\d)(\D\D\D)(\d\d)$/)
		{
		my($dd) = $1;
		my($month) = $2;
		my($yyyy) = '20' . $3;
		my($mm);
		if   ($month eq "Jan") {$mm='01';}
		elsif($month eq "Feb") {$mm='02';}
		elsif($month eq "Mar") {$mm='03';}
		elsif($month eq "Apr") {$mm='04';}
		elsif($month eq "May") {$mm='05';}
		elsif($month eq "Jun") {$mm='06';}
		elsif($month eq "Jul") {$mm='07';}
		elsif($month eq "Aug") {$mm='08';}
		elsif($month eq "Sep") {$mm='09';}
		elsif($month eq "Oct") {$mm='10';}
		elsif($month eq "Nov") {$mm='11';}
		elsif($month eq "Dec") {$mm='12';}
		$datestamp = "$yyyy$mm$dd";
		}
	else
		{
		$datestamp = "Current";
		}
	return $datestamp;
	}

sub makeFileList($)
	{
	my($logwildcard) = $_[0];
	my(@lognames) = glob($logwildcard);
	if(scalar(@lognames) == 0) {die "Fatal error, logfilelist.cgi: wildcard $logwildcard produces no matching files\n\n";}
	my($logname);
	my(%loghash) = ();
	foreach $logname (@lognames)
		{
		$loghash{datestamp($logname)} = $logname;
		}
	my($fileList) = "";
	my(@logkeys) = sort {$a cmp $b} keys(%loghash);
	my($logkey);
	foreach $logkey (@logkeys)
		{
		$fileList = $fileList . $loghash{$logkey} . " ";
		}
	return($fileList);
	}
sub getWildcard()
	{
	my($logwildcard) = "undefined";
	my($conffilename) = $ENV{'HOME'} . "/.logeval/logeval.conf";
	open(INF, "<" . $conffilename) or die "\nCannot open options file " . $conffilename . "\n\n";
	while(<INF>)
		{
		my($line) = $_;
		chomp($line);
		if   ($line =~ m/log\s*wild\s*card\s*=\s*(\S*)/i)
			{$logwildcard = $1;}
		}
	if($logwildcard eq "undefined")
		{die "\nNo log wildcard defined in ". $conffilename . "\n\n";}
	return($logwildcard);
	}
	
sub main()
	{
	print makeFileList(getWildcard());
#	print makeFileList("/scratch/tclogs/troubleshooters.com-access_log*");
#	print makeFileList("/var/log/http/troubleshooters.com-access_log*");
	}

main();
